import { Verify } from '@/utils/verify/verify';


/**
 * 统计金额
 * 基于 APP/src/service/%DE_PKGPATH%/%APP_DELOGIC%-logic-base.ts.ftl 生成
 * @export
 * @class CountMoneyLogicBase
 */
export default class CountMoneyLogicBase {

    /**
     * 名称
     * 
     * @memberof  CountMoneyLogicBase
     */
    private name:string ="CountMoney";

    /**
     * 唯一标识
     * 
     * @memberof  CountMoneyLogicBase
     */
    private id:string = "8bb0cbf4ede45c9cf3da73d50831e329";

    /**
     * 默认参数名称
     * 
     * @memberof  CountMoneyLogicBase
     */
    private defaultParamName:string = "Default";

    /**
     * 参数集合
     * 
     * @memberof  CountMoneyLogicBase
     */
    private paramsMap:Map<string,any> = new Map();

    /**
     * Creates an instance of  CountMoneyLogicBase.
     * 
     * @param {*} [opts={}]
     * @memberof  CountMoneyLogicBase
     */
    constructor(opts: any = {}) {
        this.initParams(opts);
    }

    /**
     * 初始化参数集合
     * 
     * @param {*} [opts={}]
     * @memberof  CountMoneyLogicBase
     */
    public initParams(opts:any){
        this.paramsMap.set('Default',opts);
    }


    /**
     * 计算0节点结果
     * 
     * @param params 传入参数
     */
    public compute0Cond(params:any):boolean{
        return true;
    }

    /**
     * 执行逻辑
     * 
     * @param context 应用上下文
     * @param params 传入参数
     */
    public onExecute(context:any,params:any,isloading:boolean){
        return this.executeBegin(context,params,isloading);
    }


    /**
    * 开始
    * 
    * @param params 传入参数
    */
    private async executeBegin(context:any,params:any,isloading:boolean){
        //开始节点
        if(this.compute0Cond(params)){
            return this.executeRawsqlcall1(context,params,isloading);   
        }
    }

    /**
    * 统计金额
    * 
    * @param context 应用上下文
    * @param params 传入参数
    */
    private async executeRawsqlcall1(context:any,params:any,isloading:boolean){
        // RAWSQLCALL暂未支持
        console.log("RAWSQLCALL暂未支持");
        return this.paramsMap.get(this.defaultParamName).data;
    }


}