/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'ibz5orderid',
          prop: 'ibz5orderid',
          dataType: 'PICKUP',
        },
        {
          name: 'ibz5orderdetailid',
          prop: 'ibz5orderdetailid',
          dataType: 'GUID',
        },
        {
          name: 'ibz5uniproductname',
          prop: 'ibz5uniproductname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'ibz5uniproductid',
          prop: 'ibz5uniproductid',
          dataType: 'PICKUP',
        },
        {
          name: 'srfmajortext',
          prop: 'ibz5orderdetailname',
          dataType: 'TEXT',
        },
        {
          name: 'srfkey',
          prop: 'ibz5orderdetailid',
          dataType: 'GUID',
          isEditable:true
        },
        {
          name: 'srfdataaccaction',
          prop: 'ibz5orderdetailid',
          dataType: 'GUID',
        },
        {
          name: 'amount',
          prop: 'amount',
          dataType: 'FLOAT',
        },
        {
          name: 'unit',
          prop: 'unit',
          dataType: 'PICKUPDATA',
        },
        {
          name: 'unitprice',
          prop: 'unitprice',
          dataType: 'PICKUPDATA',
        },
        {
          name: 'ibz5ordername',
          prop: 'ibz5ordername',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'quantity',
          prop: 'quantity',
          dataType: 'INT',
        },
        {
          name: 'updatedate',
          prop: 'updatedate',
          dataType: 'DATETIME',
        },
        {
          name: 'ibz5orderdetail',
          prop: 'ibz5orderdetailid',
        },

        {
          name:'size',
          prop:'size',
          dataType: 'QUERYPARAM'
        },
        {
          name:'query',
          prop:'query',
          dataType: 'QUERYPARAM'
        },
        {
          name:'filter',
          prop:'filter',
          dataType: 'QUERYPARAM'
        },
        {
          name:'page',
          prop:'page',
          dataType: 'QUERYPARAM'
        },
        {
          name:'sort',
          prop:'sort',
          dataType: 'QUERYPARAM'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata',
          dataType: 'QUERYPARAM'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}