package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.*;
import lombok.experimental.Accessors;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[IBIZSample0004DTO]
 */
@Getter
@Setter
@NoArgsConstructor
@ApiModel("多版本流程")
public class IBIZSample0004DTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 建立时间
     */
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("建立时间")
    private Timestamp createDate;

    /**
     * 建立人
     */
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty("建立人")
    private String createMan;

    /**
     * 多版本流程标识
     */
    @JsonProperty("ibizsample0004id")
    @JSONField(name = "ibizsample0004id")
    @ApiModelProperty("多版本流程标识")
    private String ibizSample0004Id;

    /**
     * 名称
     */
    @JsonProperty("ibizsample0004name")
    @JSONField(name = "ibizsample0004name")
    @ApiModelProperty("名称")
    private String ibizSample0004Name;

    /**
     * 订单金额
     */
    @JsonProperty("je")
    @JSONField(name = "je")
    @ApiModelProperty("订单金额")
    private BigDecimal je;

    /**
     * 订单时间
     */
    @JsonProperty("mvdate")
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "mvdate" , format = "yyyy-MM-dd")
    @ApiModelProperty("订单时间")
    private Timestamp mvDate;

    /**
     * 备注
     */
    @JsonProperty("memo")
    @JSONField(name = "memo")
    @ApiModelProperty("备注")
    private String memo;

    /**
     * 更新时间
     */
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("更新时间")
    private Timestamp updateDate;

    /**
     * 更新人
     */
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty("更新人")
    private String updateMan;

    /**
     * 工作流实例
     */
    @JsonProperty("wfinstanceid")
    @JSONField(name = "wfinstanceid")
    @ApiModelProperty("工作流实例")
    private String wfInstanceId;

    /**
     * 状态
     */
    @JsonProperty("wfmvstate")
    @JSONField(name = "wfmvstate")
    @ApiModelProperty("状态")
    private String wfmvState;

    /**
     * 工作流步骤
     */
    @JsonProperty("wfmvstep")
    @JSONField(name = "wfmvstep")
    @ApiModelProperty("工作流步骤")
    private String wfmvStep;

    /**
     * 工作流步骤
     */
    @JsonProperty("wfstate")
    @JSONField(name = "wfstate")
    @ApiModelProperty("工作流步骤")
    private Integer wfState;

    /**
     * 工作流版本
     */
    @JsonProperty("wfversion")
    @JSONField(name = "wfversion")
    @ApiModelProperty("工作流版本")
    private String wfVersion;

    /**
     * 订单类型
     */
    @JsonProperty("wfmvtype")
    @JSONField(name = "wfmvtype")
    @ApiModelProperty("订单类型")
    private String wfmvtype;


    /**
     * 设置 [名称]
     */
    public void setIbizSample0004Name(String ibizSample0004Name) {
        this.ibizSample0004Name = ibizSample0004Name;
        this.modify("ibizsample0004name", ibizSample0004Name);
    }

    /**
     * 设置 [订单金额]
     */
    public void setJe(BigDecimal je) {
        this.je = je;
        this.modify("je", je);
    }

    /**
     * 设置 [订单时间]
     */
    public void setMvDate(Timestamp mvDate) {
        this.mvDate = mvDate;
        this.modify("mvdate", mvDate);
    }

    /**
     * 设置 [备注]
     */
    public void setMemo(String memo) {
        this.memo = memo;
        this.modify("memo", memo);
    }

    /**
     * 设置 [工作流实例]
     */
    public void setWfInstanceId(String wfInstanceId) {
        this.wfInstanceId = wfInstanceId;
        this.modify("wfinstanceid", wfInstanceId);
    }

    /**
     * 设置 [状态]
     */
    public void setWfmvState(String wfmvState) {
        this.wfmvState = wfmvState;
        this.modify("wfmvstate", wfmvState);
    }

    /**
     * 设置 [工作流步骤]
     */
    public void setWfmvStep(String wfmvStep) {
        this.wfmvStep = wfmvStep;
        this.modify("wfmvstep", wfmvStep);
    }

    /**
     * 设置 [工作流步骤]
     */
    public void setWfState(Integer wfState) {
        this.wfState = wfState;
        this.modify("wfstate", wfState);
    }

    /**
     * 设置 [工作流版本]
     */
    public void setWfVersion(String wfVersion) {
        this.wfVersion = wfVersion;
        this.modify("wfversion", wfVersion);
    }

    /**
     * 设置 [订单类型]
     */
    public void setWfmvtype(String wfmvtype) {
        this.wfmvtype = wfmvtype;
        this.modify("wfmvtype", wfmvtype);
    }


}
