package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZAPPCTRL;
import cn.ibizlab.core.sample.filter.IBIZAPPCTRLSearchContext;

public interface IBIZAPPCTRLService extends IService<IBIZAPPCTRL> {

    default IBIZAPPCTRLService getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZAPPCTRL get(IBIZAPPCTRL et);
    default IBIZAPPCTRL get(String key) {
        IBIZAPPCTRL et = new IBIZAPPCTRL();
        et.setIbizappctrlid(key);
        return getSelf().get(et);
    }
    default List<IBIZAPPCTRL> getByIds(Collection<String> ids) {
        List<IBIZAPPCTRL> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZAPPCTRL et = new IBIZAPPCTRL();
            et.setIbizappctrlid(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZAPPCTRL> getByEntities(List<IBIZAPPCTRL> entities);

    IBIZAPPCTRL getDraft(IBIZAPPCTRL et);

    Integer checkKey(IBIZAPPCTRL et);

    boolean create(IBIZAPPCTRL et);
    boolean createBatch(List<IBIZAPPCTRL> list);

    boolean update(IBIZAPPCTRL et);
    boolean updateBatch(List<IBIZAPPCTRL> list);

    boolean save(IBIZAPPCTRL et);
    boolean saveBatch(List<IBIZAPPCTRL> list);

    default boolean remove(String key) {
        IBIZAPPCTRL et = new IBIZAPPCTRL();
        et.setIbizappctrlid(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZAPPCTRL et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZAPPCTRL> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZAPPCTRL et = new IBIZAPPCTRL();
            et.setIbizappctrlid(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZAPPCTRL> entities);

    Page<IBIZAPPCTRL> searchDefault(IBIZAPPCTRLSearchContext context);
    List<IBIZAPPCTRL> listDefault(IBIZAPPCTRLSearchContext context);


    /**
     * 自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);

    /**
     * 自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);
}