/**
 * GroupByCodelistList 部件模型
 *
 * @export
 * @class GroupByCodelistListModel
 */
export default class GroupByCodelistListModel {

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof GroupByCodelistListListMode
	 */
	public getDataItems(): any[] {
		return [
			{
				name: 'type',
        codelist:{tag:'BookType',codelistType:'STATIC'},
			},
			{
				name: 'price',
			},
			{
				name: 'ibizbookid',
			},
			{
				name: 'ibizbookname',
			},
			{
				name: 'author',
			},
			{
				name: 'press',
			},
			{
				name: 'booknumber',
			},
			{
				name: 'srfkey',
				prop: 'ibizbookid',
				dataType: 'GUID',
			},
			{
				name: 'srfmajortext',
				prop: 'ibizbookname',
				dataType: 'TEXT',
			},
			{
				name: 'srfmstag',
			},
			{
				name: 'ibizbook',
				prop: 'ibizbookid',
				dataType: 'FONTKEY',
			},
      {
        name: 'n_ibizbookname_like',
        prop: 'n_ibizbookname_like',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_price_gtandeq',
        prop: 'n_price_gtandeq',
        dataType: 'QUERYPARAM'
      },

      {
        name:'size',
        prop:'size'
      },
      {
        name:'query',
        prop:'query'
      },
      {
        name:'sort',
        prop:'sort'
      },
      {
        name:'page',
        prop:'page'
      },
      // 前端新增修改标识，新增为"0",修改为"1"或未设值
      {
        name: 'srffrontuf',
        prop: 'srffrontuf',
        dataType: 'TEXT',
      },
		]
	}

}