import { Verify } from '@/utils/verify/verify';


/**
 * 更新员工名称
 *
 * @export
 * @class UpdateYGNameLogicBase
 */
export default class UpdateYGNameLogicBase {

    /**
     * 名称
     * 
     * @memberof  UpdateYGNameLogicBase
     */
    private name:string ="UpdateYGName";

    /**
     * 唯一标识
     * 
     * @memberof  UpdateYGNameLogicBase
     */
    private id:string = "3b789da8320bc8c143ba44a5f7cc24d8";

    /**
     * 默认参数名称
     * 
     * @memberof  UpdateYGNameLogicBase
     */
    private defaultParamName:string = "Default";

    /**
     * 参数集合
     * 
     * @memberof  UpdateYGNameLogicBase
     */
    private paramsMap:Map<string,any> = new Map();

    /**
     * Creates an instance of  UpdateYGNameLogicBase.
     * 
     * @param {*} [opts={}]
     * @memberof  UpdateYGNameLogicBase
     */
    constructor(opts: any = {}) {
        this.initParams(opts);
    }

    /**
     * 初始化参数集合
     * 
     * @param {*} [opts={}]
     * @memberof  UpdateYGNameLogicBase
     */
    public initParams(opts:any){
        this.paramsMap.set('Default',opts);
    }


    /**
     * 计算0节点结果
     * 
     * @param params 传入参数
     */
    public compute0Cond(params:any):boolean{
        return true;
    }

    /**
     * 执行逻辑
     * 
     * @param context 应用上下文
     * @param params 传入参数
     */
    public onExecute(context:any,params:any,isloading:boolean){
        return this.executeBegin(context,params,isloading);
    }


    /**
    * 开始
    * 
    * @param params 传入参数
    */
    private async executeBegin(context:any,params:any,isloading:boolean){
        //开始节点
        if(this.compute0Cond(params)){
            return this.executeRawsqlcall1(context,params,isloading);   
        }
    }

    /**
    * 更新员工名称
    * 
    * @param context 应用上下文
    * @param params 传入参数
    */
    private async executeRawsqlcall1(context:any,params:any,isloading:boolean){
        // RAWSQLCALL暂未支持
        console.log("RAWSQLCALL暂未支持");
        return this.paramsMap.get(this.defaultParamName).data;
    }


}