import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 示例实体01服务对象基类
 *
 * @export
 * @class IBIZSample0001ServiceBase
 * @extends {EntityServie}
 */
export default class IBIZSample0001ServiceBase extends EntityService {

    /**
     * Creates an instance of  IBIZSample0001ServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  IBIZSample0001ServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof IBIZSample0001ServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='ibizsample0001';
        this.APPDEKEY = 'ibizsample0001id';
        this.APPDENAME = 'ibizsample0001s';
        this.APPDETEXT = 'ibizsample0001name';
        this.APPNAME = 'web';
        this.SYSTEMNAME = 'demosys';
    }

// 实体接口

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZSample0001ServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.ibizsample0002 && context.ibizsample0001){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/ibizsample0002s/${context.ibizsample0002}/ibizsample0001s/${context.ibizsample0001}/checkkey`,data,isloading);
            
            return res;
        }
            let res:any = Http.getInstance().post(`/ibizsample0001s/${context.ibizsample0001}/checkkey`,data,isloading);
            return res;
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZSample0001ServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.ibizsample0002 && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/ibizsample0002s/${context.ibizsample0002}/ibizsample0001s`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/ibizsample0001s`,data,isloading);
        
        return res;
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZSample0001ServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.ibizsample0002 && context.ibizsample0001){
            let res:any = await Http.getInstance().get(`/ibizsample0002s/${context.ibizsample0002}/ibizsample0001s/${context.ibizsample0001}`,isloading);
            
            return res;
        }
            let res:any = await Http.getInstance().get(`/ibizsample0001s/${context.ibizsample0001}`,isloading);
            
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZSample0001ServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.ibizsample0002 && true){
            let res:any = await Http.getInstance().get(`/ibizsample0002s/${context.ibizsample0002}/ibizsample0001s/getdraft`,isloading);
            res.data.ibizsample0001 = data.ibizsample0001;
            
            return res;
        }
        let res:any = await  Http.getInstance().get(`/ibizsample0001s/getdraft`,isloading);
        res.data.ibizsample0001 = data.ibizsample0001;
        
        return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZSample0001ServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.ibizsample0002 && context.ibizsample0001){
            let res:any = Http.getInstance().delete(`/ibizsample0002s/${context.ibizsample0002}/ibizsample0001s/${context.ibizsample0001}`,isloading);
            return res;
        }
            let res:any = Http.getInstance().delete(`/ibizsample0001s/${context.ibizsample0001}`,isloading);
            return res;
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZSample0001ServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.ibizsample0002 && context.ibizsample0001){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/ibizsample0002s/${context.ibizsample0002}/ibizsample0001s/${context.ibizsample0001}/save`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/ibizsample0001s/${context.ibizsample0001}/save`,data,isloading);
            
            return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZSample0001ServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.ibizsample0002 && context.ibizsample0001){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/ibizsample0002s/${context.ibizsample0002}/ibizsample0001s/${context.ibizsample0001}`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/ibizsample0001s/${context.ibizsample0001}`,data,isloading);
            
            return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZSample0001ServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.ibizsample0002 && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            let res:any = Http.getInstance().get(`/ibizsample0002s/${context.ibizsample0002}/ibizsample0001s/fetchdefault`,tempData,isloading);
            return res;
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/ibizsample0001s/fetchdefault`,tempData,isloading);
        return res;
    }

    /**
     * searchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZSample0001ServiceBase
     */
    public async searchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.ibizsample0002 && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return await Http.getInstance().post(`/ibizsample0002s/${context.ibizsample0002}/ibizsample0001s/searchdefault`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return await Http.getInstance().post(`/ibizsample0001s/searchdefault`,tempData,isloading);
    }

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZSample0001ServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.ibizsample0002 && context.ibizsample0001){
            let res:any = Http.getInstance().get(`/ibizsample0002s/${context.ibizsample0002}/ibizsample0001s/${context.ibizsample0001}/select`,isloading);
            
            return res;
        }
            let res:any = Http.getInstance().get(`/ibizsample0001s/${context.ibizsample0001}/select`,isloading);
            
            return res;
    }
}