import IBIZBOOKService from '@/service/ibizbook/ibizbook-service';
import { Verify } from '@/utils/verify/verify';


/**
 * 图书初始化
 *
 * @export
 * @class InitDataLogicBase
 */
export default class InitDataLogicBase {

    /**
     * 名称
     * 
     * @memberof  InitDataLogicBase
     */
    private name:string ="initData";

    /**
     * 唯一标识
     * 
     * @memberof  InitDataLogicBase
     */
    private id:string = "274ea8009f339d4f90b019af91a7d7c7";

    /**
     * 默认参数名称
     * 
     * @memberof  InitDataLogicBase
     */
    private defaultParamName:string = "Default";

    /**
     * 参数集合
     * 
     * @memberof  InitDataLogicBase
     */
    private paramsMap:Map<string,any> = new Map();

    /**
     * Creates an instance of  InitDataLogicBase.
     * 
     * @param {*} [opts={}]
     * @memberof  InitDataLogicBase
     */
    constructor(opts: any = {}) {
        this.initParams(opts);
    }

    /**
     * 初始化参数集合
     * 
     * @param {*} [opts={}]
     * @memberof  InitDataLogicBase
     */
    public initParams(opts:any){
        this.paramsMap.set('Default',opts);
    }


    /**
     * 计算0节点结果
     * 
     * @param params 传入参数
     */
    public compute0Cond(params:any):boolean{
        return true;
    }

    /**
     * 执行逻辑
     * 
     * @param context 应用上下文
     * @param params 传入参数
     */
    public onExecute(context:any,params:any,isloading:boolean){
        return this.executeBegin(context,params,isloading);
    }


    /**
    * 开始
    * 
    * @param params 传入参数
    */
    private async executeBegin(context:any,params:any,isloading:boolean){
        //开始节点
        if(this.compute0Cond(params)){
            return this.executeDeaction1(context,params,isloading);   
        }
    }

    /**
    * 获取图书数据
    * 
    * @param context 应用上下文
    * @param params 传入参数
    */
    private async executeDeaction1(context:any,params:any,isloading:boolean){
        // 行为处理节点
        let result: any;
        let actionParam:any = this.paramsMap.get('Default');
        const targetService:IBIZBOOKService = new IBIZBOOKService();
        if (targetService['Get'] && targetService['Get'] instanceof Function) {
            result = await targetService['Get'](actionParam.context,actionParam.data, false);
        }
        if(result && result.status == 200){
            Object.assign(actionParam.data,result.data);
        return this.paramsMap.get(this.defaultParamName).data;
        }
    }


}