import IBIZBOOKService from '@/service/ibizbook/ibizbook-service';
import { Verify } from '@/utils/verify/verify';


/**
 * 完成图书流程
 *
 * @export
 * @class FinishLogicBase
 */
export default class FinishLogicBase {

    /**
     * 名称
     * 
     * @memberof  FinishLogicBase
     */
    private name:string ="finish";

    /**
     * 唯一标识
     * 
     * @memberof  FinishLogicBase
     */
    private id:string = "dcf0dffa1a9ac902d57bb7a357e85465";

    /**
     * 默认参数名称
     * 
     * @memberof  FinishLogicBase
     */
    private defaultParamName:string = "Default";

    /**
     * 参数集合
     * 
     * @memberof  FinishLogicBase
     */
    private paramsMap:Map<string,any> = new Map();

    /**
     * Creates an instance of  FinishLogicBase.
     * 
     * @param {*} [opts={}]
     * @memberof  FinishLogicBase
     */
    constructor(opts: any = {}) {
        this.initParams(opts);
    }

    /**
     * 初始化参数集合
     * 
     * @param {*} [opts={}]
     * @memberof  FinishLogicBase
     */
    public initParams(opts:any){
        this.paramsMap.set('Default',opts);
    }


    /**
     * 计算0节点结果
     * 
     * @param params 传入参数
     */
    public compute0Cond(params:any):boolean{
        return true;
    }

    /**
     * 执行逻辑
     * 
     * @param context 应用上下文
     * @param params 传入参数
     */
    public onExecute(context:any,params:any,isloading:boolean){
        return this.executeBegin(context,params,isloading);
    }


    /**
    * 开始
    * 
    * @param params 传入参数
    */
    private async executeBegin(context:any,params:any,isloading:boolean){
        //开始节点
        if(this.compute0Cond(params)){
            return this.executeDeaction1(context,params,isloading);   
        }
    }

    /**
    * 完成图书状态
    * 
    * @param context 应用上下文
    * @param params 传入参数
    */
    private async executeDeaction1(context:any,params:any,isloading:boolean){
        // 行为处理节点
        let result: any;
        let actionParam:any = this.paramsMap.get('Default');
        const targetService:IBIZBOOKService = new IBIZBOOKService();
        if (targetService['Update'] && targetService['Update'] instanceof Function) {
            result = await targetService['Update'](actionParam.context,actionParam.data, false);
        }
        if(result && result.status == 200){
            Object.assign(actionParam.data,result.data);
        return this.paramsMap.get(this.defaultParamName).data;
        }
    }


}