import ViewMessageService from '../view-message-service';
/**
 * 实体树视图视图消息服务对象基类
 *
 * @export
 * @class ViewMsg96MessageServiceBase
 */
export default class ViewMsg96MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg96MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg96MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg96MessageServiceBase
     */
    public initBasicParam(){
        this.id = "d784bea3333bde328d9d31d9ab42c552";
        this.name = "实体树视图";
        this.codename = "ViewMsg96";
        this.title = "";
        this.content = "本示例展示实体树视图基本功能。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg96MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}