import ViewMessageService from '../view-message-service';
/**
 * K线图视图消息服务对象基类
 *
 * @export
 * @class ViewMsg89MessageServiceBase
 */
export default class ViewMsg89MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg89MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg89MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg89MessageServiceBase
     */
    public initBasicParam(){
        this.id = "2586593795ea60bbd7bcf36421c39b20";
        this.name = "K线图";
        this.codename = "ViewMsg89";
        this.title = "";
        this.content = "本示例展示订单不同审核状态金额K线图。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg89MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}