import ViewMessageService from '../view-message-service';
/**
 * 常规表格视图消息服务对象基类
 *
 * @export
 * @class ViewMsg88MessageServiceBase
 */
export default class ViewMsg88MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg88MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg88MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg88MessageServiceBase
     */
    public initBasicParam(){
        this.id = "240b096e230b9e30eff1675069d7ed4b";
        this.name = "常规表格";
        this.codename = "ViewMsg88";
        this.title = "";
        this.content = "本示例展示常规表格视图：包含快速搜索栏和工具栏等。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg88MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}