import ViewMessageService from '../view-message-service';
/**
 * 常规编辑视图视图消息服务对象基类
 *
 * @export
 * @class ViewMsg85MessageServiceBase
 */
export default class ViewMsg85MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg85MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg85MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg85MessageServiceBase
     */
    public initBasicParam(){
        this.id = "3ad9b45ed480968fc3448d5f4d5ad96d";
        this.name = "常规编辑视图";
        this.codename = "ViewMsg85";
        this.title = "";
        this.content = "本示例展示常规编辑视图的内置功能。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg85MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}