import ViewMessageService from '../view-message-service';
/**
 * 自定义视图视图消息服务对象基类
 *
 * @export
 * @class ViewMsg84MessageServiceBase
 */
export default class ViewMsg84MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg84MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg84MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg84MessageServiceBase
     */
    public initBasicParam(){
        this.id = "2d0357d5c3897fe584d2c7ea3a1d3264";
        this.name = "自定义视图";
        this.codename = "ViewMsg84";
        this.title = "";
        this.content = "本示例展示自定义视图。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg84MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}