import ViewMessageService from '../view-message-service';
/**
 * 常规导航视图视图消息服务对象基类
 *
 * @export
 * @class ViewMsg82MessageServiceBase
 */
export default class ViewMsg82MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg82MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg82MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg82MessageServiceBase
     */
    public initBasicParam(){
        this.id = "a4f533cbc74d07b2bfd248161293d976";
        this.name = "常规导航视图";
        this.codename = "ViewMsg82";
        this.title = "";
        this.content = "本示例展示常规导航视图的内置功能。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg82MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}