import ViewMessageService from '../view-message-service';
/**
 * 数据视图自定义插件视图消息服务对象基类
 *
 * @export
 * @class ViewMsg73MessageServiceBase
 */
export default class ViewMsg73MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg73MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg73MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg73MessageServiceBase
     */
    public initBasicParam(){
        this.id = "220f719da5c47464947c8a723c61a81a";
        this.name = "数据视图自定义插件";
        this.codename = "ViewMsg73";
        this.title = "";
        this.content = "本示例展示数据视图自定义插件。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg73MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}