import ViewMessageService from '../view-message-service';
/**
 * 实体数据看板部件视图消息服务对象基类
 *
 * @export
 * @class ViewMsg69MessageServiceBase
 */
export default class ViewMsg69MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg69MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg69MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg69MessageServiceBase
     */
    public initBasicParam(){
        this.id = "7079df95727be22b65303ae8df14321e";
        this.name = "实体数据看板部件";
        this.codename = "ViewMsg69";
        this.title = "";
        this.content = "本示例展示实体数据看板部件的基础用法。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg69MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}