import ViewMessageService from '../view-message-service';
/**
 * 应用门户视图消息服务对象基类
 *
 * @export
 * @class ViewMsg68MessageServiceBase
 */
export default class ViewMsg68MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg68MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg68MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg68MessageServiceBase
     */
    public initBasicParam(){
        this.id = "4191c043eaf08552e830a34746a9007a";
        this.name = "应用门户";
        this.codename = "ViewMsg68";
        this.title = "";
        this.content = "本示例展示应用看板视图。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg68MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}