import ViewMessageService from '../view-message-service';
/**
 * 编辑器插件示例视图消息服务对象基类
 *
 * @export
 * @class ViewMsg66MessageServiceBase
 */
export default class ViewMsg66MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg66MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg66MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg66MessageServiceBase
     */
    public initBasicParam(){
        this.id = "d4fdeb583c642e3766dd5943621d73d2";
        this.name = "编辑器插件示例";
        this.codename = "ViewMsg66";
        this.title = "";
        this.content = "该示例展示编辑器的自定义插件。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg66MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}