import ViewMessageService from '../view-message-service';
/**
 * 表单主状态视图消息服务对象基类
 *
 * @export
 * @class ViewMsg62MessageServiceBase
 */
export default class ViewMsg62MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg62MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg62MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg62MessageServiceBase
     */
    public initBasicParam(){
        this.id = "473ce982b72d3ca95ed502bb704ed946";
        this.name = "表单主状态";
        this.codename = "ViewMsg62";
        this.title = "";
        this.content = "本示例展示表单主状态（通过主状态控制按钮及界面行为状态）：图书类型为武侠时禁用打开文档。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg62MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}