import ViewMessageService from '../view-message-service';
/**
 * 树表格视图消息服务对象基类
 *
 * @export
 * @class ViewMsg57MessageServiceBase
 */
export default class ViewMsg57MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg57MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg57MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg57MessageServiceBase
     */
    public initBasicParam(){
        this.id = "443da8982fa2aad9741cdb039d7a3d00";
        this.name = "树表格";
        this.codename = "ViewMsg57";
        this.title = "";
        this.content = "本示例展示实体树表格视图内置功能。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg57MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}