import ViewMessageService from '../view-message-service';
/**
 * 向导面板---状态属性视图消息服务对象基类
 *
 * @export
 * @class ViewMsg52MessageServiceBase
 */
export default class ViewMsg52MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg52MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg52MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg52MessageServiceBase
     */
    public initBasicParam(){
        this.id = "f6e2b2655fdb29092cda56232c769ede";
        this.name = "向导面板---状态属性";
        this.codename = "ViewMsg52";
        this.title = "";
        this.content = "本示例展示了根据每一步骤的行为返回的状态属性的值再决定跳转哪一个向导表单；这儿上一步行为把状态属性（stepstatus）改成了step1，下一步行为把状态属性（stepstatus）改成了step3，实际使用根据业务场景而定。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg52MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}