import ViewMessageService from '../view-message-service';
/**
 * 日历导航--时间轴视图消息服务对象基类
 *
 * @export
 * @class ViewMsg48MessageServiceBase
 */
export default class ViewMsg48MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg48MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg48MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg48MessageServiceBase
     */
    public initBasicParam(){
        this.id = "fd04a1551cb20d37c503002a8193cb42";
        this.name = "日历导航--时间轴";
        this.codename = "ViewMsg48";
        this.title = "";
        this.content = "本示例展示日历导航--时间轴样式的内置功能：包含搜索栏、部件工具栏、导航关系等。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg48MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}