import ViewMessageService from '../view-message-service';
/**
 * 数据视图自动分组视图消息服务对象基类
 *
 * @export
 * @class ViewMsg39MessageServiceBase
 */
export default class ViewMsg39MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg39MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg39MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg39MessageServiceBase
     */
    public initBasicParam(){
        this.id = "cc36e7571e0f4698c4bf26675e4f92c4";
        this.name = "数据视图自动分组";
        this.codename = "ViewMsg39";
        this.title = "";
        this.content = "本示例展示数据视图的自动分组功能：分组属性为作者。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg39MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}