import ViewMessageService from '../view-message-service';
/**
 * 编辑表单---内置功能视图消息服务对象基类
 *
 * @export
 * @class ViewMsg37MessageServiceBase
 */
export default class ViewMsg37MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg37MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg37MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg37MessageServiceBase
     */
    public initBasicParam(){
        this.id = "46b2799cf109dbe9a5eb49cff00d1289";
        this.name = "编辑表单---内置功能";
        this.codename = "ViewMsg37";
        this.title = "";
        this.content = "本示例展示表单的内置功能主要包含表单的增删改查等行为，这些行为供界面行为和视图固有逻辑调用。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg37MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}