import ViewMessageService from '../view-message-service';
/**
 * 编辑表单---值规则视图消息服务对象基类
 *
 * @export
 * @class ViewMsg36MessageServiceBase
 */
export default class ViewMsg36MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg36MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg36MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg36MessageServiceBase
     */
    public initBasicParam(){
        this.id = "4e22f0b23c22dd9845ffa5e3fadb269d";
        this.name = "编辑表单---值规则";
        this.codename = "ViewMsg36";
        this.title = "";
        this.content = "本示例展示表单的值规则功能：表单值规则分为系统值规则和属性值规则，其中系统值规则已支持正则式和脚本，属性值规则已支持常规规则、正则式规则、数值范围规则、字符长度规则、系统值规则和规则组。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg36MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}