import ViewMessageService from '../view-message-service';
/**
 * 编辑视图（分页关系）视图消息服务对象基类
 *
 * @export
 * @class ViewMsg30MessageServiceBase
 */
export default class ViewMsg30MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg30MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg30MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg30MessageServiceBase
     */
    public initBasicParam(){
        this.id = "d487c20fa467fba6e0d74b6095659328";
        this.name = "编辑视图（分页关系）";
        this.codename = "ViewMsg30";
        this.title = "";
        this.content = "本示例展示编辑视图（分页关系）：将关联信息的数据列表以分页标签的形式进行呈现，订单为主实体，订单明细为从实体，关系界面为订单明细表格视图。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg30MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}