import ViewMessageService from '../view-message-service';
/**
 * 编辑视图（上下关系）视图消息服务对象基类
 *
 * @export
 * @class ViewMsg29MessageServiceBase
 */
export default class ViewMsg29MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg29MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg29MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg29MessageServiceBase
     */
    public initBasicParam(){
        this.id = "02ff42538d1f2c3380c0461909edac30";
        this.name = "编辑视图（上下关系）";
        this.codename = "ViewMsg29";
        this.title = "";
        this.content = "本示例展示编辑视图（上下关系）：上方呈现主信息，下方呈现关联信息的形式进行展现，订单为主实体，订单明细为从实体，关系界面为订单明细表格视图。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg29MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}