import ViewMessageService from '../view-message-service';
/**
 * 表单-重置项视图消息服务对象基类
 *
 * @export
 * @class ViewMsg26MessageServiceBase
 */
export default class ViewMsg26MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg26MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg26MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg26MessageServiceBase
     */
    public initBasicParam(){
        this.id = "7ef88fb2ddc058567246df338aba4878";
        this.name = "表单-重置项";
        this.codename = "ViewMsg26";
        this.title = "";
        this.content = "本示例展示表单的表单项重置功能：展示内容包含【订单名称】变化、将重置【产品名称】、【单位】、【单价】、【数量】、【小计】。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg26MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}