import ViewMessageService from '../view-message-service';
/**
 * 编辑表单动态显示视图消息服务对象基类
 *
 * @export
 * @class ViewMsg17MessageServiceBase
 */
export default class ViewMsg17MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg17MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg17MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg17MessageServiceBase
     */
    public initBasicParam(){
        this.id = "8935c573a21af46fce09d95faa7d7486";
        this.name = "编辑表单动态显示";
        this.codename = "ViewMsg17";
        this.title = "";
        this.content = "本示例展示表单的动态显示功能：文本框已配置动态显示，开关打开时显示文本框。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg17MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}