import CounterService from '../counter-service';
/**
 * 树视图计数器计数器服务对象基类
 *
 * @export
 * @class TreeViewCounterServiceBase
 */
export default class TreeCounterServiceBase extends CounterService {

    /**
     * Creates an instance of  TreeCounterServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  TreeCounterServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
        this.initCounterData();
        this.timer = setInterval(() => {
            this.fetchCounterData(this.context,this.viewparams);
        }, 30000);
    }

    /**
     * 初始化当前计数器数据对象
     * 
     * @param {*} [opts={}]
     * @memberof  TreeCounterServiceBase
     */
    public initCounterData(){
        this.fetchCounterData(this.context,this.viewparams);
    }

    /**
     * 查询数据
     * 
     * @param {*} [opts={}]
     * @memberof  TreeCounterServiceBase
     */
    public async fetchCounterData(context:any,data:any){
    }

    /**
     * 刷新数据
     *
     * @memberof TreeCounterServiceBase
     */
    public async refreshData(){
        if (this['fetchCounterData'] && this['fetchCounterData'] instanceof Function) {
            await this.fetchCounterData(this.context,this.viewparams);
        }
    }

}