import ViewMessageService from '../view-message-service';
/**
 * 表格视图行编辑视图消息视图消息服务对象基类
 *
 * @export
 * @class ViewMsg19MessageServiceBase
 */
export default class ViewMsg19MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg19MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg19MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg19MessageServiceBase
     */
    public initBasicParam(){
        this.id = "FD039917-EF88-44DB-B7B5-AA114D638640";
        this.name = "表格视图行编辑视图消息";
        this.codename = "ViewMsg19";
        this.title = "";
        this.content = "本示例展示实体表格的行编辑功能";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg19MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}