import ViewMessageService from '../view-message-service';
/**
 * 树导航视图消息服务对象基类
 *
 * @export
 * @class ViewMsg45MessageServiceBase
 */
export default class ViewMsg45MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg45MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg45MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg45MessageServiceBase
     */
    public initBasicParam(){
        this.id = "4F93770F-36C2-4869-AE98-EFCE7D95A5A6";
        this.name = "树导航";
        this.codename = "ViewMsg45";
        this.title = "";
        this.content = "本示例展示树导航的内置功能，包含搜索栏、部件工具栏、导航关系、树节点类型（静态、实体、代码表）。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg45MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}