import ViewMessageService from '../view-message-service';
/**
 * 搜索表单---内置功能视图消息服务对象基类
 *
 * @export
 * @class ViewMsg38MessageServiceBase
 */
export default class ViewMsg38MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg38MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg38MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg38MessageServiceBase
     */
    public initBasicParam(){
        this.id = "B5C1DF0F-FDC0-4AA8-A3AE-269190787C02";
        this.name = "搜索表单---内置功能";
        this.codename = "ViewMsg38";
        this.title = "";
        this.content = "本示例展示搜索表单的内置功能；主要包含搜索表单的新建默认值，搜索表单的搜索功能与重置功能";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg38MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}