import ViewMessageService from '../view-message-service';
/**
 * 卡片视图导航视图消息服务对象基类
 *
 * @export
 * @class ViewMsg47MessageServiceBase
 */
export default class ViewMsg47MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg47MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg47MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg47MessageServiceBase
     */
    public initBasicParam(){
        this.id = "24208DBE-7121-4C02-B76D-209887CA5054";
        this.name = "卡片视图导航";
        this.codename = "ViewMsg47";
        this.title = "";
        this.content = "本示例展示卡片视图导航的内置功能，包含快速分组、搜索栏、部件工具栏、导航关系等。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg47MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}