package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.IBIZViewMsg;
import cn.ibizlab.core.sample.filter.IBIZViewMsgSearchContext;
import cn.ibizlab.core.sample.service.IIBIZViewMsgService;

import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.helper.DEFieldCacheMap;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import cn.ibizlab.core.sample.mapper.IBIZViewMsgMapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.alibaba.fastjson.JSONObject;
import org.springframework.util.StringUtils;

/**
 * 实体[视图消息源] 服务对象接口实现
 */
@Slf4j
@Service("IBIZViewMsgServiceImpl")
public class IBIZViewMsgServiceImpl extends ServiceImpl<IBIZViewMsgMapper, IBIZViewMsg> implements IIBIZViewMsgService {


    protected int batchSize = 500;

    @Override
    @Transactional
    public boolean create(IBIZViewMsg et) {
        if(!this.retBool(this.baseMapper.insert(et))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getIbizviewmsgid()), et);
        return true;
    }

    @Override
    @Transactional
    public void createBatch(List<IBIZViewMsg> list) {
        this.saveBatch(list, batchSize);
    }

    @Override
    @Transactional
    public boolean update(IBIZViewMsg et) {
        if(!update(et, (Wrapper) et.getUpdateWrapper(true).eq("ibizviewmsgid", et.getIbizviewmsgid()))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getIbizviewmsgid()), et);
        return true;
    }

    @Override
    @Transactional
    public void updateBatch(List<IBIZViewMsg> list) {
        updateBatchById(list, batchSize);
    }

    @Override
    @Transactional
    public boolean remove(String key) {
        boolean result = removeById(key);
        return result ;
    }

    @Override
    @Transactional
    public void removeBatch(Collection<String> idList) {
        removeByIds(idList);
    }

    @Override
    @Transactional
    public IBIZViewMsg get(String key) {
        IBIZViewMsg et = getById(key);
        if(et == null){
            et = new IBIZViewMsg();
            et.setIbizviewmsgid(key);
        }
        else {
        }
        return et;
    }

    @Override
    public IBIZViewMsg getDraft(IBIZViewMsg et) {
        return et;
    }

    @Override
    public boolean checkKey(IBIZViewMsg et) {
        return (!ObjectUtils.isEmpty(et.getIbizviewmsgid())) && (!Objects.isNull(this.getById(et.getIbizviewmsgid())));
    }
    @Override
    @Transactional
    public boolean save(IBIZViewMsg et) {
        if(!saveOrUpdate(et)) {
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public boolean saveOrUpdate(IBIZViewMsg et) {
        if (null == et) {
            return false;
        } else {
            return checkKey(et) ? this.update(et) : this.create(et);
        }
    }

    @Override
    @Transactional
    public boolean saveBatch(Collection<IBIZViewMsg> list) {
        saveOrUpdateBatch(list,batchSize);
        return true;
    }

    @Override
    @Transactional
    public void saveBatch(List<IBIZViewMsg> list) {
        saveOrUpdateBatch(list,batchSize);
    }



    /**
     * 查询集合 数据集
     */
    @Override
    public Page<IBIZViewMsg> searchDefault(IBIZViewMsgSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZViewMsg> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZViewMsg>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }







    @Override
    public List<JSONObject> select(String sql, Map param){
        return this.baseMapper.selectBySQL(sql,param);
    }

    @Override
    @Transactional
    public boolean execute(String sql , Map param){
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        if (sql.toLowerCase().trim().startsWith("insert")) {
            return this.baseMapper.insertBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("update")) {
            return this.baseMapper.updateBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("delete")) {
            return this.baseMapper.deleteBySQL(sql,param);
        }
        log.warn("暂未支持的SQL语法");
        return true;
    }

    @Override
    public List<IBIZViewMsg> getIbizviewmsgByIds(List<String> ids) {
         return this.listByIds(ids);
    }

    @Override
    public List<IBIZViewMsg> getIbizviewmsgByEntities(List<IBIZViewMsg> entities) {
        List ids =new ArrayList();
        for(IBIZViewMsg entity : entities){
            Serializable id=entity.getIbizviewmsgid();
            if(!ObjectUtils.isEmpty(id)){
                ids.add(id);
            }
        }
        if(ids.size()>0) {
            return this.listByIds(ids);
        }
        else {
            return entities;
        }
    }




}



