package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.IBIZCPU;
import cn.ibizlab.core.sample.filter.IBIZCPUSearchContext;
import cn.ibizlab.core.sample.service.IIBIZCPUService;

import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.helper.DEFieldCacheMap;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import cn.ibizlab.core.sample.mapper.IBIZCPUMapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.alibaba.fastjson.JSONObject;
import org.springframework.util.StringUtils;

/**
 * 实体[处理器] 服务对象接口实现
 */
@Slf4j
@Service("IBIZCPUServiceImpl")
public class IBIZCPUServiceImpl extends ServiceImpl<IBIZCPUMapper, IBIZCPU> implements IIBIZCPUService {


    protected int batchSize = 500;

    @Override
    @Transactional
    public boolean create(IBIZCPU et) {
        createIndexMajorEntityData(et);
        if(!this.retBool(this.baseMapper.insert(et))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getIbizcpuid()), et);
        return true;
    }

    @Override
    @Transactional
    public void createBatch(List<IBIZCPU> list) {
        this.saveBatch(list, batchSize);
    }

    @Override
    @Transactional
    public boolean update(IBIZCPU et) {
        ibizhardwareService.update(ibizcpuInheritMapping.toIbizhardware(et));
        if(!update(et, (Wrapper) et.getUpdateWrapper(true).eq("ibizcpuid", et.getIbizcpuid()))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getIbizcpuid()), et);
        return true;
    }

    @Override
    @Transactional
    public void updateBatch(List<IBIZCPU> list) {
        updateBatchById(list, batchSize);
    }

    @Override
    @Transactional
    public boolean remove(String key) {
        ibizhardwareService.remove(key);
        boolean result = removeById(key);
        return result ;
    }

    @Override
    @Transactional
    public void removeBatch(Collection<String> idList) {
        removeByIds(idList);
    }

    @Override
    @Transactional
    public IBIZCPU get(String key) {
        IBIZCPU et = getById(key);
        if(et == null){
            et = new IBIZCPU();
            et.setIbizcpuid(key);
        }
        else {
        }
        return et;
    }

    @Override
    public IBIZCPU getDraft(IBIZCPU et) {
        return et;
    }

    @Override
    public boolean checkKey(IBIZCPU et) {
        return (!ObjectUtils.isEmpty(et.getIbizcpuid())) && (!Objects.isNull(this.getById(et.getIbizcpuid())));
    }
    @Override
    @Transactional
    public boolean save(IBIZCPU et) {
        if(!saveOrUpdate(et)) {
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public boolean saveOrUpdate(IBIZCPU et) {
        if (null == et) {
            return false;
        } else {
            return checkKey(et) ? this.update(et) : this.create(et);
        }
    }

    @Override
    @Transactional
    public boolean saveBatch(Collection<IBIZCPU> list) {
        saveOrUpdateBatch(list,batchSize);
        return true;
    }

    @Override
    @Transactional
    public void saveBatch(List<IBIZCPU> list) {
        saveOrUpdateBatch(list,batchSize);
    }



    /**
     * 查询集合 DEFAULT
     */
    @Override
    public Page<IBIZCPU> searchDefault(IBIZCPUSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZCPU> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZCPU>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }






    @Autowired
    cn.ibizlab.core.sample.mapping.IBIZCPUInheritMapping ibizcpuInheritMapping;
    @Autowired
    @Lazy
    protected cn.ibizlab.core.sample.service.IIBIZHardwareService ibizhardwareService;

    /**
     * 创建索引主实体数据
     * @param et
     */
    private void createIndexMajorEntityData(IBIZCPU et){
        if(ObjectUtils.isEmpty(et.getIbizcpuid()))
            et.setIbizcpuid((String)et.getDefaultKey(true));
        cn.ibizlab.core.sample.domain.IBIZHardware ibizhardware =ibizcpuInheritMapping.toIbizhardware(et);
        ibizhardware.set("ibizhardwaretype","CPU");
        ibizhardwareService.create(ibizhardware);
    }

    @Override
    public List<JSONObject> select(String sql, Map param){
        return this.baseMapper.selectBySQL(sql,param);
    }

    @Override
    @Transactional
    public boolean execute(String sql , Map param){
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        if (sql.toLowerCase().trim().startsWith("insert")) {
            return this.baseMapper.insertBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("update")) {
            return this.baseMapper.updateBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("delete")) {
            return this.baseMapper.deleteBySQL(sql,param);
        }
        log.warn("暂未支持的SQL语法");
        return true;
    }

    @Override
    public List<IBIZCPU> getIbizcpuByIds(List<String> ids) {
         return this.listByIds(ids);
    }

    @Override
    public List<IBIZCPU> getIbizcpuByEntities(List<IBIZCPU> entities) {
        List ids =new ArrayList();
        for(IBIZCPU entity : entities){
            Serializable id=entity.getIbizcpuid();
            if(!ObjectUtils.isEmpty(id)){
                ids.add(id);
            }
        }
        if(ids.size()>0) {
            return this.listByIds(ids);
        }
        else {
            return entities;
        }
    }




}



