package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.sample.domain.IBIZViewMsg;
import cn.ibizlab.core.sample.filter.IBIZViewMsgSearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[IBIZViewMsg] 服务对象接口
 */
public interface IIBIZViewMsgService extends IService<IBIZViewMsg> {

    boolean create(IBIZViewMsg et);
    void createBatch(List<IBIZViewMsg> list);
    boolean update(IBIZViewMsg et);
    void updateBatch(List<IBIZViewMsg> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    IBIZViewMsg get(String key);
    IBIZViewMsg getDraft(IBIZViewMsg et);
    boolean checkKey(IBIZViewMsg et);
    boolean save(IBIZViewMsg et);
    void saveBatch(List<IBIZViewMsg> list);
    Page<IBIZViewMsg> searchDefault(IBIZViewMsgSearchContext context);
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

    List<IBIZViewMsg> getIbizviewmsgByIds(List<String> ids);
    List<IBIZViewMsg> getIbizviewmsgByEntities(List<IBIZViewMsg> entities);
}


