package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.sample.domain.IBIZSupplier;
import cn.ibizlab.core.sample.filter.IBIZSupplierSearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[IBIZSupplier] 服务对象接口
 */
public interface IIBIZSupplierService extends IService<IBIZSupplier> {

    boolean create(IBIZSupplier et);
    void createBatch(List<IBIZSupplier> list);
    boolean update(IBIZSupplier et);
    void updateBatch(List<IBIZSupplier> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    IBIZSupplier get(String key);
    IBIZSupplier getDraft(IBIZSupplier et);
    boolean checkKey(IBIZSupplier et);
    boolean save(IBIZSupplier et);
    void saveBatch(List<IBIZSupplier> list);
    Page<IBIZSupplier> searchDefault(IBIZSupplierSearchContext context);
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

    List<IBIZSupplier> getIbizsupplierByIds(List<String> ids);
    List<IBIZSupplier> getIbizsupplierByEntities(List<IBIZSupplier> entities);
}


