package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.sample.domain.IBIZSample0019;
import cn.ibizlab.core.sample.filter.IBIZSample0019SearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[IBIZSample0019] 服务对象接口
 */
public interface IIBIZSample0019Service extends IService<IBIZSample0019> {

    boolean create(IBIZSample0019 et);
    void createBatch(List<IBIZSample0019> list);
    boolean update(IBIZSample0019 et);
    void updateBatch(List<IBIZSample0019> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    IBIZSample0019 get(String key);
    IBIZSample0019 getDraft(IBIZSample0019 et);
    boolean checkKey(IBIZSample0019 et);
    boolean save(IBIZSample0019 et);
    void saveBatch(List<IBIZSample0019> list);
    Page<IBIZSample0019> searchDefault(IBIZSample0019SearchContext context);
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

    List<IBIZSample0019> getIbizsample0019ByIds(List<String> ids);
    List<IBIZSample0019> getIbizsample0019ByEntities(List<IBIZSample0019> entities);
}


