package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.sample.domain.IBIZSample0015;
import cn.ibizlab.core.sample.filter.IBIZSample0015SearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[IBIZSample0015] 服务对象接口
 */
public interface IIBIZSample0015Service extends IService<IBIZSample0015> {

    boolean create(IBIZSample0015 et);
    void createBatch(List<IBIZSample0015> list);
    boolean update(IBIZSample0015 et);
    void updateBatch(List<IBIZSample0015> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    IBIZSample0015 get(String key);
    IBIZSample0015 getDraft(IBIZSample0015 et);
    boolean checkKey(IBIZSample0015 et);
    boolean save(IBIZSample0015 et);
    void saveBatch(List<IBIZSample0015> list);
    Page<IBIZSample0015> searchDefault(IBIZSample0015SearchContext context);
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

    List<IBIZSample0015> getIbizsample0015ByIds(List<String> ids);
    List<IBIZSample0015> getIbizsample0015ByEntities(List<IBIZSample0015> entities);
}


