package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.sample.domain.IBIZSample0004;
import cn.ibizlab.core.sample.filter.IBIZSample0004SearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[IBIZSample0004] 服务对象接口
 */
public interface IIBIZSample0004Service extends IService<IBIZSample0004> {

    boolean create(IBIZSample0004 et);
    void createBatch(List<IBIZSample0004> list);
    boolean update(IBIZSample0004 et);
    void updateBatch(List<IBIZSample0004> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    IBIZSample0004 get(String key);
    IBIZSample0004 getDraft(IBIZSample0004 et);
    boolean checkKey(IBIZSample0004 et);
    boolean save(IBIZSample0004 et);
    void saveBatch(List<IBIZSample0004> list);
    Page<IBIZSample0004> searchDefault(IBIZSample0004SearchContext context);
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

    List<IBIZSample0004> getIbizsample0004ByIds(List<String> ids);
    List<IBIZSample0004> getIbizsample0004ByEntities(List<IBIZSample0004> entities);
}


