package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.sample.domain.IBIZSample0001;
import cn.ibizlab.core.sample.filter.IBIZSample0001SearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[IBIZSample0001] 服务对象接口
 */
public interface IIBIZSample0001Service extends IService<IBIZSample0001> {

    boolean create(IBIZSample0001 et);
    void createBatch(List<IBIZSample0001> list);
    boolean update(IBIZSample0001 et);
    void updateBatch(List<IBIZSample0001> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    IBIZSample0001 get(String key);
    IBIZSample0001 getDraft(IBIZSample0001 et);
    boolean checkKey(IBIZSample0001 et);
    boolean save(IBIZSample0001 et);
    void saveBatch(List<IBIZSample0001> list);
    Page<IBIZSample0001> searchDefault(IBIZSample0001SearchContext context);
    List<IBIZSample0001> selectByIbizsample0002id(String ibizsample0002id);
    void removeByIbizsample0002id(String ibizsample0002id);
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

    List<IBIZSample0001> getIbizsample0001ByIds(List<String> ids);
    List<IBIZSample0001> getIbizsample0001ByEntities(List<IBIZSample0001> entities);
}


