package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.sample.domain.IBIZOrderType;
import cn.ibizlab.core.sample.filter.IBIZOrderTypeSearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[IBIZOrderType] 服务对象接口
 */
public interface IIBIZOrderTypeService extends IService<IBIZOrderType> {

    boolean create(IBIZOrderType et);
    void createBatch(List<IBIZOrderType> list);
    boolean update(IBIZOrderType et);
    void updateBatch(List<IBIZOrderType> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    IBIZOrderType get(String key);
    IBIZOrderType getDraft(IBIZOrderType et);
    boolean checkKey(IBIZOrderType et);
    IBIZOrderType resetCodeList(IBIZOrderType et);
    boolean resetCodeListBatch(List<IBIZOrderType> etList);
    boolean save(IBIZOrderType et);
    void saveBatch(List<IBIZOrderType> list);
    Page<IBIZOrderType> searchDefault(IBIZOrderTypeSearchContext context);
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

    List<IBIZOrderType> getIbizordertypeByIds(List<String> ids);
    List<IBIZOrderType> getIbizordertypeByEntities(List<IBIZOrderType> entities);
}


