package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.sample.domain.IBIZOrder;
import cn.ibizlab.core.sample.filter.IBIZOrderSearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[IBIZOrder] 服务对象接口
 */
public interface IIBIZOrderService extends IService<IBIZOrder> {

    boolean create(IBIZOrder et);
    void createBatch(List<IBIZOrder> list);
    IBIZOrder createTemp(IBIZOrder et);
    IBIZOrder createTempMajor(IBIZOrder et);
    boolean update(IBIZOrder et);
    void updateBatch(List<IBIZOrder> list);
    IBIZOrder updateTemp(IBIZOrder et);
    IBIZOrder updateTempMajor(IBIZOrder et);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    IBIZOrder removeTemp(IBIZOrder et);
    IBIZOrder removeTempMajor(IBIZOrder et);
    IBIZOrder get(String key);
    IBIZOrder getTemp(IBIZOrder et);
    IBIZOrder getTempMajor(IBIZOrder et);
    IBIZOrder getDraft(IBIZOrder et);
    IBIZOrder getDraftTemp(IBIZOrder et);
    IBIZOrder getDraftTempMajor(IBIZOrder et);
    IBIZOrder bUIAction(IBIZOrder et);
    boolean bUIActionBatch(List<IBIZOrder> etList);
    boolean checkKey(IBIZOrder et);
    boolean save(IBIZOrder et);
    void saveBatch(List<IBIZOrder> list);
    Page<IBIZOrder> searchCSDY(IBIZOrderSearchContext context);
    Page<IBIZOrder> searchCurState30(IBIZOrderSearchContext context);
    Page<IBIZOrder> searchDDJETJBB(IBIZOrderSearchContext context);
    Page<IBIZOrder> searchDDReport(IBIZOrderSearchContext context);
    Page<IBIZOrder> searchDYDDMXSJY(IBIZOrderSearchContext context);
    Page<IBIZOrder> searchDefault(IBIZOrderSearchContext context);
    Page<IBIZOrder> searchEchartsDefaultDataSource(IBIZOrderSearchContext context);
    Page<IBIZOrder> searchGaugeDataSource(IBIZOrderSearchContext context);
    Page<IBIZOrder> searchGaugeDataSourceByTime(IBIZOrderSearchContext context);
    Page<IBIZOrder> searchLOGIC_22(IBIZOrderSearchContext context);
    Page<IBIZOrder> searchRadarDataSource(IBIZOrderSearchContext context);
    Page<IBIZOrder> searchSHZOrder(IBIZOrderSearchContext context);
    Page<IBIZOrder> searchState10(IBIZOrderSearchContext context);
    Page<IBIZOrder> searchState30(IBIZOrderSearchContext context);
    Page<IBIZOrder> searchState40(IBIZOrderSearchContext context);
    Page<IBIZOrder> searchXECX(IBIZOrderSearchContext context);
    List<IBIZOrder> selectByIbizcustomerid(String ibizcustomerid);
    void removeByIbizcustomerid(String ibizcustomerid);
    JSONObject importData(List<IBIZOrder> entities, int batchSize, boolean isIgnoreError);

    @Async("asyncExecutor")
    void asyncImportData(List<IBIZOrder> entities, int batchSize, boolean isIgnoreError);
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

    List<IBIZOrder> getIbizorderByIds(List<String> ids);
    List<IBIZOrder> getIbizorderByEntities(List<IBIZOrder> entities);
}


