package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.sample.domain.IBIZBOOK;
import cn.ibizlab.core.sample.filter.IBIZBOOKSearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[IBIZBOOK] 服务对象接口
 */
public interface IIBIZBOOKService extends IService<IBIZBOOK> {

    boolean create(IBIZBOOK et);
    void createBatch(List<IBIZBOOK> list);
    boolean update(IBIZBOOK et);
    void updateBatch(List<IBIZBOOK> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    IBIZBOOK get(String key);
    IBIZBOOK getDraft(IBIZBOOK et);
    boolean checkKey(IBIZBOOK et);
    boolean save(IBIZBOOK et);
    void saveBatch(List<IBIZBOOK> list);
    IBIZBOOK updatePress(IBIZBOOK et);
    boolean updatePressBatch(List<IBIZBOOK> etList);
    Page<IBIZBOOK> searchDefault(IBIZBOOKSearchContext context);
    JSONObject importData(List<IBIZBOOK> entities, int batchSize, boolean isIgnoreError);

    @Async("asyncExecutor")
    void asyncImportData(List<IBIZBOOK> entities, int batchSize, boolean isIgnoreError);
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

    List<IBIZBOOK> getIbizbookByIds(List<String> ids);
    List<IBIZBOOK> getIbizbookByEntities(List<IBIZBOOK> entities);
}


