package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.sample.domain.IBIZAPPEXTENDEDITOR;
import cn.ibizlab.core.sample.filter.IBIZAPPEXTENDEDITORSearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[IBIZAPPEXTENDEDITOR] 服务对象接口
 */
public interface IIBIZAPPEXTENDEDITORService extends IService<IBIZAPPEXTENDEDITOR> {

    boolean create(IBIZAPPEXTENDEDITOR et);
    void createBatch(List<IBIZAPPEXTENDEDITOR> list);
    boolean update(IBIZAPPEXTENDEDITOR et);
    void updateBatch(List<IBIZAPPEXTENDEDITOR> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    IBIZAPPEXTENDEDITOR get(String key);
    IBIZAPPEXTENDEDITOR getDraft(IBIZAPPEXTENDEDITOR et);
    boolean checkKey(IBIZAPPEXTENDEDITOR et);
    boolean save(IBIZAPPEXTENDEDITOR et);
    void saveBatch(List<IBIZAPPEXTENDEDITOR> list);
    Page<IBIZAPPEXTENDEDITOR> searchDefault(IBIZAPPEXTENDEDITORSearchContext context);
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

    List<IBIZAPPEXTENDEDITOR> getIbizappextendeditorByIds(List<String> ids);
    List<IBIZAPPEXTENDEDITOR> getIbizappextendeditorByEntities(List<IBIZAPPEXTENDEDITOR> entities);
}


