package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.sample.domain.Appkanban;
import cn.ibizlab.core.sample.filter.AppkanbanSearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[Appkanban] 服务对象接口
 */
public interface IAppkanbanService extends IService<Appkanban> {

    boolean create(Appkanban et);
    void createBatch(List<Appkanban> list);
    boolean update(Appkanban et);
    void updateBatch(List<Appkanban> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    Appkanban get(String key);
    Appkanban getDraft(Appkanban et);
    boolean checkKey(Appkanban et);
    boolean save(Appkanban et);
    void saveBatch(List<Appkanban> list);
    Page<Appkanban> searchDefault(AppkanbanSearchContext context);
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

    List<Appkanban> getAppkanbanByIds(List<String> ids);
    List<Appkanban> getAppkanbanByEntities(List<Appkanban> entities);
}


