

package cn.ibizlab.core.sample.mapping;

import org.mapstruct.*;
import cn.ibizlab.core.sample.domain.IBIZStorage;
import cn.ibizlab.core.sample.domain.IBIZHardware;
import java.util.List;

@Mapper(componentModel = "spring", uses = {})
public interface IBIZStorageInheritMapping {

    @Mappings({
        @Mapping(source ="ibizstorageid",target = "ibizhardwareid"),
        @Mapping(source ="ibizstoragename",target = "ibizhardwarename"),
        @Mapping(target ="focusNull",ignore = true),
    })
    IBIZHardware toIbizhardware(IBIZStorage ibizstorage);

    @Mappings({
        @Mapping(source ="ibizhardwareid" ,target = "ibizstorageid"),
        @Mapping(source ="ibizhardwarename" ,target = "ibizstoragename"),
        @Mapping(target ="focusNull",ignore = true),
    })
    IBIZStorage toIbizstorage(IBIZHardware ibizhardware);

    List<IBIZHardware> toIbizhardware(List<IBIZStorage> ibizstorage);

    List<IBIZStorage> toIbizstorage(List<IBIZHardware> ibizhardware);

}


