

package cn.ibizlab.core.sample.mapping;

import org.mapstruct.*;
import cn.ibizlab.core.sample.domain.IBIZSoftwareSuit;
import cn.ibizlab.core.sample.domain.IBIZUNIProduct;
import java.util.List;

@Mapper(componentModel = "spring", uses = {})
public interface IBIZSoftwareSuitInheritMapping {

    @Mappings({
        @Mapping(source ="ibizsoftwaresuitid",target = "ibizuniproductid"),
        @Mapping(source ="ibizsoftwaresuitname",target = "ibizuniproductname"),
        @Mapping(target ="focusNull",ignore = true),
    })
    IBIZUNIProduct toIbizuniproduct(IBIZSoftwareSuit ibizsoftwaresuit);

    @Mappings({
        @Mapping(source ="ibizuniproductid" ,target = "ibizsoftwaresuitid"),
        @Mapping(source ="ibizuniproductname" ,target = "ibizsoftwaresuitname"),
        @Mapping(target ="focusNull",ignore = true),
    })
    IBIZSoftwareSuit toIbizsoftwaresuit(IBIZUNIProduct ibizuniproduct);

    List<IBIZUNIProduct> toIbizuniproduct(List<IBIZSoftwareSuit> ibizsoftwaresuit);

    List<IBIZSoftwareSuit> toIbizsoftwaresuit(List<IBIZUNIProduct> ibizuniproduct);

}


